/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.block;

import DE.siemens.ad.logo.model.BinaryInBlockConnector;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareChangedEvent;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.Logo;
import DE.siemens.ad.logo.model.MessageManager;
import DE.siemens.ad.logo.model.MessageParameter;
import DE.siemens.ad.logo.model.ParameterInBlockConnector;
import DE.siemens.ad.logo.model.PseudoParameter;
import DE.siemens.ad.logo.model.SpecialBlock;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Logger.ErrorInfo;
import DE.siemens.ad.logo.util.MessageLine;
import java.util.ArrayList;

public class MessageBlock
extends SpecialBlock {
    static final long serialVersionUID = 1L;
    private int serializedDataVersion = 1;

    public MessageBlock() {
    }

    public MessageBlock(WiringDiagram wiringDiagram) {
        super(wiringDiagram);
    }

    public Block deepCopy() {
        Block clonedBlock = super.deepCopy();
        MessageParameter srcParam = (MessageParameter)this.getParameter();
        MessageParameter cloneParam = (MessageParameter)clonedBlock.getParameter();
        if (srcParam.isRTF()) {
            for (int j = 0; j < 2; ++j) {
                MessageParameter.MessageText srcText = srcParam.getMessageRTF(j);
                if (srcText == null) continue;
                cloneParam.getMessageRTFs()[j] = new MessageParameter.MessageText();
                cloneParam.getMessageRTF(j).copyFrom(srcText, cloneParam);
            }
            cloneParam.setMessage(null);
        } else {
            int i;
            MessageLine[] srcLines = srcParam.getMessage();
            MessageLine[] cloneLines = cloneParam.getMessage();
            for (i = 0; i < cloneLines.length; ++i) {
                cloneLines[i].copyFrom(srcLines[i], false);
            }
            for (i = 0; i < cloneParam.getMessageRTFs().length; ++i) {
                cloneParam.getMessageRTFs()[i] = null;
            }
        }
        return clonedBlock;
    }

    protected boolean calculateBinaryValue() {
        return this.getParameter().getValue(((BinaryInBlockConnector)this.fInConnectors[0]).calculateBinaryValue());
    }

    protected int getDefaultOrder() {
        return 2100;
    }

    public int[] getMemoryResources(Hardware hardware) {
        int[] result = super.getMemoryResources(hardware);
        result[12] = 1;
        return result;
    }

    public int getResourceIndex() {
        return 12;
    }

    protected void initInConnectors() {
        this.fInConnectors = new InBlockConnector[3];
        this.fInConnectors[0] = new BinaryInBlockConnector(this, false, "En");
        MessageParameter paraObj = new MessageParameter(this);
        this.fInConnectors[1] = new ParameterInBlockConnector((Block)this, paraObj, "P");
        this.fInConnectors[2] = new ParameterInBlockConnector((Block)this, new PseudoParameter(this), "Par");
    }

    public boolean postDelete(WiringDiagram wd) {
        MessageParameter messageParameter = (MessageParameter)this.getParameter();
        MessageLine[] messageLines = messageParameter.getMessage();
        for (int i = 0; i < messageLines.length; ++i) {
            messageLines[i].removeAsParameterListener();
        }
        return true;
    }

    public String preInsert(WiringDiagram wd) {
        String ret = super.preInsert(wd);
        if (((Logo)wd.getHardware()).isUploading()) {
            return ret;
        }
        MessageParameter msgParam = (MessageParameter)this.getParameter();
        MessageManager msgManager = wd.getMessageManager();
        if (wd.getHardware().supports("NeedMessageNumber")) {
            int newNumber = msgManager.getFreeMessageNumber();
            if (newNumber < 0) {
                throw new IllegalArgumentException(this.getLocalizedName(true) + ": Can not find valid MessageNumber");
            }
            msgParam.setMsgNumber(newNumber);
        } else {
            msgParam.setMsgNumber(0);
        }
        Integer oldPrio = msgParam.getPriority();
        if (msgManager.isPriorityUsed(oldPrio)) {
            int freePriority = msgManager.getFreePriority();
            if (freePriority < 0) {
                throw new IllegalArgumentException(this.getLocalizedName(true) + ": Can not find valid priority");
            }
            msgParam.setPriority(freePriority);
        }
        this.setWiringDiagram(wd);
        if (wd.getMessageManager().isRTFMessage()) {
            if (!msgParam.isRTF()) {
                msgParam.syncPlainToRTFStyle(wd.getMessageGlobalInfo().getSelectedCharSet(0));
            } else {
                for (int i = 0; i < msgParam.getMessageRTFs().length; ++i) {
                    MessageParameter.MessageText orgText = msgParam.getMessageRTFs()[i];
                    if (orgText == null) continue;
                    int textID = -1;
                    textID = i == 1 && msgParam.getMessageRTFs()[0] != null ? wd.getMessageManager().getFreeMessageTextIDExcept(msgParam.getMessageRTFs()[0].getTextID()) : wd.getMessageManager().getFreeMessageTextID();
                    if (textID == -1) {
                        msgParam.disableTextRTF(i);
                        continue;
                    }
                    orgText.setTextID(textID);
                    msgParam.transferContentsToCharset(i, wd.getMessageGlobalInfo().getSelectedCharSet(i));
                }
            }
        } else if (msgParam.isRTF()) {
            msgParam.syncRTFToPlainStyle();
        }
        return ret;
    }

    public void hardwareChangeFinished(HardwareChangedEvent hardwareChangedEvent) {
        super.hardwareChangeFinished(hardwareChangedEvent);
        ((MessageParameter)this.getParameter()).hardwareChangeFinished(hardwareChangedEvent);
    }

    public boolean isResourceAvailable(WiringDiagram wd) {
        boolean result = super.isResourceAvailable(wd);
        if (wd.getMessageManager().isRTFMessage() && wd.getMessageManager().getFreeMessageTextID() == -1) {
            result = false;
        }
        return result;
    }

    public boolean isResourceAvailable(WiringDiagram wd, ArrayList errorList) {
        boolean result = super.isResourceAvailable(wd, errorList);
        if (wd.getMessageManager().isRTFMessage() && wd.getMessageManager().getFreeMessageTextID() == -1) {
            result = false;
            String s = Language.getString("hardware.MessageText", "Resource");
            s = Language.getString("error.notAvailable", "% not available", s);
            errorList.add(new ErrorInfo(this, s, wd.getHardware()));
        }
        return result;
    }
}

